<?php
/************************************************************
 *  C1 Digital Telegram Bot - Loan Calculator
 *  Author: Siwan Ghafari
 *  Version: v3.0 — Rich Output Style (per image example)
 ************************************************************/

error_reporting(E_ALL);
ini_set('display_errors', 1);
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
date_default_timezone_set('Asia/Tehran');

/** BOT TOKEN **/
$API_TOKEN = "8228923625:AAEmRUi8U-IhxFVGuEgP4kRHLGLuWj0GweE";

/** DATABASE INFO **/
$db_host = "localhost";
$db_user = "c1digico_loansystem";
$db_pass = "mWr2pE}b8hagk=BQ";
$db_name = "c1digico_loansystem";
$conn     = new mysqli($db_host, $db_user, $db_pass, $db_name);
$conn->set_charset("utf8mb4");

/** READ UPDATE **/
$update = json_decode(file_get_contents('php://input'), true);
if (!$update) exit;

$message  = $update['message'] ?? null;
$callback = $update['callback_query'] ?? null;

$user_ip = $_SERVER['REMOTE_ADDR'];
$chat_id = $message['chat']['id'] ?? ($callback['message']['chat']['id'] ?? null);
$telegram_id = $message['from']['id'] ?? ($callback['from']['id'] ?? null);
$text = trim($message['text'] ?? '');

/* ------------------------------------------------------
 * /start - require phone number
 * ------------------------------------------------------ */
if ($text == "/start") {
    $keyboard = [
        "keyboard" => [
            [
                ["text" => "📱 ارسال شماره موبایل", "request_contact" => true]
            ]
        ],
        "resize_keyboard" => true,
        "one_time_keyboard" => true
    ];
    sendMessage($chat_id,
        "👋 خوش آمدید به ربات محاسبه اقساط فروشگاه C1 Digital\n\nلطفاً شماره موبایل خود را ارسال کنید:",
        $keyboard
    );
    logEvent($telegram_id, $user_ip, $chat_id, "/start", null, null);
    exit;
}

/* ------------------------------------------------------
 * Contact
 * ------------------------------------------------------ */
if (isset($message['contact'])) {
    $phone = $message['contact']['phone_number'];
    sendMessage($chat_id,
        "✅ شماره شما ثبت شد: $phone\n\nلطفاً مبلغ دستگاه را وارد کنید (به تومان):");
    logEvent($telegram_id, $user_ip, $chat_id, "phone_sent", null, $phone);
    exit;
}

/* ------------------------------------------------------
 * Callback - calculate installment (rich format)
 * ------------------------------------------------------ */
if (isset($callback['data'])) {
    $months = intval($callback['data']);
    $price_text = $callback['message']['text'];

    preg_match('/(\d[\d,]*)/', $price_text, $match);
    $price = floatval(str_replace(',', '', $match[1] ?? '0'));

    if ($months > 0 && $months <= 6 && $price > 0) {

        // --- Calculation ---
        $downpayment = $price * 0.5;
        $remain = $price - $downpayment;
        $rate = 0.05;
        for ($i = 1; $i <= $months; $i++) $remain *= (1 + $rate);
        $totalPay = $downpayment + $remain;
        $installment = round($remain / $months);

        $totalProfitPercent = $months * 5;
        $profitValue = $remain - ($price - $downpayment);

        // --- Build Rich Message ---
        $msg = "🏷️ *C1 Digital*\n"
             . "*محاسبه اقساط فروشگاه*\n\n"
             . "💰 *قیمت نقدی:* " . number_format($price) . " تومان\n"
             . "💵 *پیش‌پرداخت (۵۰٪):* " . number_format($downpayment) . " تومان\n"
             . "📦 *مانده:* " . number_format($price - $downpayment) . " تومان\n"
             . "🗓️ *مدت اقساط:* $months ماه\n"
             . "📈 *سود کل:* " . $totalProfitPercent . "%\n\n"
             . "💸 *مانده با سود:* " . number_format($remain) . " تومان\n"
             . "🧮 *مبلغ هر قسط:* " . number_format($installment) . " تومان\n"
             . "💵 *مجموع کل پرداختی:* " . number_format($totalPay) . " تومان\n\n"
             . "📅 *برنامه پرداخت:*\n";

        for ($i = 1; $i <= $months; $i++) {
            $msg .= "🟢 ماه $i: " . number_format($installment) . " تومان\n";
        }

        sendMessageMarkdown($chat_id, $msg);
        logEvent($telegram_id, $user_ip, $chat_id, "installment_$months", $callback['data'], null);
        exit;
    }
}

/* ------------------------------------------------------
 * Enter Price
 * ------------------------------------------------------ */
if (preg_match('/\d+/', convertPersianNumber($text))) {
    $price = floatval(convertPersianNumber($text));

    if ($price > 0) {
        $inlineKeyboard = [
            "inline_keyboard" => [
                [
                    ["text" => "۱ ماه", "callback_data" => "1"],
                    ["text" => "۲ ماه", "callback_data" => "2"],
                    ["text" => "۳ ماه", "callback_data" => "3"]
                ],
                [
                    ["text" => "۴ ماه", "callback_data" => "4"],
                    ["text" => "۵ ماه", "callback_data" => "5"],
                    ["text" => "۶ ماه", "callback_data" => "6"]
                ]
            ]
        ];
        sendMessage($chat_id,
            "💲 مبلغ نقدی: " . number_format($price) . " تومان\n"
            . "لطفاً مدت اقساط را انتخاب کنید:",
            $inlineKeyboard
        );
        logEvent($telegram_id, $user_ip, $chat_id, "price_input", null, null);
        exit;
    }
}

/* ------------------------------------------------------
 * Fallback
 * ------------------------------------------------------ */
if ($text !== "/start" && !isset($message['contact']) && !isset($callback['data'])) {
    sendMessage($chat_id,
        "⚙️ لطفاً ابتدا /start را بزنید و شماره موبایل خود را ارسال کنید.");
    logEvent($telegram_id, $user_ip, $chat_id, "default_fallback", null, null);
}

/* ------------------------------------------------------
 * FUNCTIONS
 * ------------------------------------------------------ */
function sendMessage($chat_id, $text, $keyboard = null) {
    global $API_TOKEN;
    $url = "https://api.telegram.org/bot$API_TOKEN/sendMessage";
    $data = [
        "chat_id" => $chat_id,
        "text" => $text,
        "reply_markup" => $keyboard ? json_encode($keyboard, true) : null
    ];
    sendRequest($url, $data);
}

function sendMessageMarkdown($chat_id, $text) {
    global $API_TOKEN;
    $url = "https://api.telegram.org/bot$API_TOKEN/sendMessage";
    $data = [
        "chat_id" => $chat_id,
        "text" => $text,
        "parse_mode" => "Markdown"
    ];
    sendRequest($url, $data);
}

function sendRequest($url, $data) {
    $options = [
        "http" => [
            "header" => "Content-Type: application/x-www-form-urlencoded\r\n",
            "method" => "POST",
            "content" => http_build_query($data),
            "timeout" => 5
        ]
    ];
    $context = stream_context_create($options);
    @file_get_contents($url, false, $context);
}

function convertPersianNumber($str) {
    $persianDigits = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $englishDigits = ['0','1','2','3','4','5','6','7','8','9'];
    return str_replace($persianDigits, $englishDigits, $str);
}

function logEvent($tid, $ip, $cid, $msg, $callback, $phone) {
    global $conn;
    $stmt = $conn->prepare(
        "INSERT INTO users_logs (telegram_id, user_ip, phone, message_text, callback_data, created_at)
         VALUES (?, ?, ?, ?, ?, NOW())"
    );
    $stmt->bind_param("sssss", $tid, $ip, $phone, $msg, $callback);
    $stmt->execute();
    $stmt->close();
}
?>
